<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function roles()
    {
        return $this->hasMany('App\Models\UserRole');
    }

    public function groups()
    {
        return $this->hasMany('App\Models\UserGroup');
    }

    public function projects()
    {
        return $this->hasMany('App\Models\Project');
    }

    public function tasks()
    {
        return $this->hasMany('App\Models\Task', 'assessor_id');
    }

    public function following()
    {
        return $this->hasMany('App\Models\TaskFollower');
    }

    public function projectsParticipating()
    {
        return $this->hasMany('App\Models\ProjectParticipant');
    }

    public function status()
    {
        return $this->belongsTo('App\Models\UserStatus', 'status_id');
    }

    public function paperAnswers()
    {
        return $this->hasMany('App\Models\PaperAnswers');
    }

}